require( "scripts/style.lua" );
require( "scripts/chocshopstyle.lua" );


local mm_close = false;
kButtonW = 51;
kButtonH = 46;

kButtonSpacing = 45;
kButtonY = 338;
kButtonX = 0;
kButtonX1 = 155 - kButtonW;
kButtonX2 = 265 - kButtonW;
kButtonX3 = 400 - kButtonW;
kButtonX4 = 535 - kButtonW;
kButtonX5 = 645 - kButtonW;
kButtonY1 = 400 - kButtonH;
kButtonY2 = 465 - kButtonH;
kButtonY3 = 520 - kButtonH;
kButtonY4 = 540 - kButtonH;

mm_edward25 = { edwardian_medium, 28, BlackColor };
mm_edward25w = { edwardian_medium, 25, WhiteColor };

CSMainMenuFont = { edwardian_medium, 24, WhiteColor };
CSMainMenuFont_Smaller = { edwardian_medium, 20, WhiteColor };
CSMainMenuTextStyle = {
    font = CSMainMenuFont,
    flags = kHAlignLeft + kVAlignTop,
};
Sweet_ButtonFont = {
	carlson_pro,
	25,
	Color(255,255,255,255)
};

-- Checks to see if there is a current user, 
-- and if not then attempts to create one
function CheckUsers()
	if( GetNumUsers() > 0 ) then 
		return true;
	end
	
	gEnterNameValue = "";
		
	name = DoModal( "scripts/entername.lua" );
	if( not( name == nil ) ) then
		CreateNewUser( name );
		return true;
	end
	
	return false;
end

--[[function SetWelcomeText()
    SetLabel("txt_welcome", GetString("mainmenu_welcome", GetCurrentUserName()));
    SetLabel("txt_welcome_shadow", GetString("mainmenu_welcome", GetCurrentUserName()));
end]]

MakeDialog
{
	name = "mainmenu_dialog",
	
	TMainMenu
	{
		fit = true,
		
		RWindow
		{
			name	= "mainmenu_window",
			image	= "ui/backgrounds/cs_background",

            Bitmap{
                image = "ui/backgrounds/logo",
                mask = "ui/backgrounds/logo.mask",
            },
            
            
			Text{
			    name = "txt_welcome_shadow",
			    x = 341,
			    y = 77,
			    w = 800,
			    h = 30,
			    flags = kHAlignLeft + kVAlignTop,
			    font = {edwardian_medium, 28, ShadowColor},
			    label = "mainmenu_welcome",
			},
			Text{
			    name = "txt_welcome",
			    x = 340,
			    y = 75,
			    w = 800,
			    h = 30,
			    flags = kHAlignLeft + kVAlignTop,
			    font = {edwardian_medium, 28, Color(253,200,78) },
			    label = "mainmenu_welcome",
			},
			RShrinkText{
			    name = "txt_user_shadow",
			    x = 361,
			    y = 107,
			    w = 250,
			    h = 30,
			    flags = kHAlignLeft + kVAlignTop,
			    font = {edwardian_medium, 25, ShadowColor},
			    label = "#"..GetCurrentUserName(),
			},
			RShrinkText{
			    name = "txt_user",
			    x = 360,
			    y = 105,
			    w = 250,
			    h = 35,
			    flags = kHAlignLeft + kVAlignTop,
			    font = {edwardian_medium, 25, Color(253,200,78)},
			    label = "#"..GetCurrentUserName(),
			},
			
			SetStyle( CSMMLongButtonStyle ),
			---------------------------------------------- XSell
			Button
			{
				x		= 589,
				y		= 557,
				name	= "moregames",
				Text{
				    x = 0,
				    y = 0,
				    w = kMax,
				    h = kMax,
				    label	= "mainmenu_xsell",
				    font    = {edwardian_medium, 18, WhiteColor},
				    flags   = kHAlignCenter + kVAlignCenter,
				},
				command	=
					function()
						DoModal("xsell/xsell.lua");
					end
			},
			---------------------------------------------- UpSell
			--[[Button
			{
				x		= 0,
				y		= 557,
				name	= "morechocolatier",
				Text{
				    x = 0,
				    y = 0,
				    w = kMax,
				    h = kMax,
				    label	= "mainmenu_more_chocolatier",
				    font    = {edwardian_medium, 18, WhiteColor},
				    flags   = kHAlignCenter + kVAlignCenter,
				},
				command	=
					function()
						DoTransition( kFadeToBlack );
						DoModal('scripts/upsell.lua');
						--PostMessage( CreateNamedMessage( kFadeToBlack, "DoModal('scripts/upsell.lua');" ) );
					end
			},]]
			---------------------------------------------- Debug
			Button
			{
				x		= 0,
				y		= 300,
				name	= "mainmenu_debug_button",
				font    = {edwardian_medium, 18, WhiteColor},
				label	= "#DEBUG",
				command	=
					function()
						DoModal("scripts/upsell.lua");
					end
			},
			
			---------------------------------------------- Help
			SetStyle(CSMMCenterButtonStyle),
			Button
			{
				x = 275, y = 495,
				name = "btn_help",
				Text{
				    x = 0,
				    y = 0,
				    w = kMax - 4,
				    h = kMax - 4,
				    label	= "btn_help",
				    flags   = kHAlignCenter + kVAlignCenter,
				    font    = {edwardian_medium, 22, WhiteColor},
				},
				command	=
					function()
						DoModal ( 'scripts/help.lua' );
					end
			},
			---------------------------------------------- Choose Player
			Button
			{
				x = 396, y = 495,
				name = "mainmenu_chooseplayer_button",
				Text {
					font	= {edwardian_medium, 20, WhiteColor},
					x = 0, y = 0,
					w = kMax-3, h = kMax,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "mainmenu_chooseplayer"
				},
				command	=
					function()
						DoModal( "scripts/chooseplayer.lua" );
					end
			},
			---------------------------------------------- Single Player
			SetStyle(CSMMLargeButtonStyle),
			Button
			{
				x = 259, y = 383,
				name		= "mainmenu_adventure_button",
				Text
				{
					x	= 0, 
					y	= 0,
				    w	= kMax, 
				    h   = kMax - 16,
				    font = {edwardian_medium, 26, WhiteColor},
				    flags = kHAlignCenter + kVAlignCenter,
					label	= "mainmenu_single",
				},
				
				command =
					function()
					    SetState("MainMenuScreenTime", 0);
						SetCurrentGameMode( 0 );
						if( CheckUsers() ) then
						    --if( not mm_close ) then
							    --mm_close = true;
							    DoTransition( kFadeToBlack );
							    SwapToModal( 'scripts/worldmap.lua' );
							    --PostMessage( CreateNamedMessage( kFadeToBlack, "SwapToModal( 'scripts/worldmap.lua' );" ) );
							--end
						end
					end
			},
			
			---------------------------------------------- Endless Sweets
			Button
			{	
				x = 396, y = 383,
				name		= "mainmenu_endless_button",
				Text
				{
					x	= 0, 
					y	= 0,
				    w	= kMax, 
				    h   = kMax - 16,
				    font = {edwardian_medium, 26, WhiteColor},
				    flags = kHAlignCenter + kVAlignCenter,
					label	= "mainmenu_endless",
				},
				
				command	=
					function()
				        SetState("MainMenuScreenTime", 0);
					    SetCurrentGameMode( 1 );
					    if( CheckUsers() ) then
						   -- if( not mm_close ) then
						   DoTransition( kFadeToBlack );
						   SwapToModal( 'scripts/worldmap.lua' );
							    --mm_close = true;
							    --DoTransition( kFadeToBlack, "SwapToModal( 'scripts/worldmap.lua' );" );
						        --PostMessage( CreateNamedMessage( kFadeToBlack, "SwapToModal( 'scripts/worldmap.lua' );" ) );
						    --end
					    --else
					        --SetButtonToggleState("mainmenu_endless_button", false);
					    end
					end
			},
			
			---------------------------------------------- Quit
			SetStyle(CSMMRight2ButtonStyle),
			Button
			{
				x = 612, y = 409,
				name = "mainmenu_quit",
				Text {
					font = {edwardian_medium, 24, WhiteColor},
					x = 0, y = 0,
					w = kMax - 13, h = kMax - 10,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "app_quit"
				},
				command	=
					function()
						result = DisplayDialog { "scripts/yesno.lua", body ="quit_body", title = "", width=390, height=230 };
						if( result == 'yes' ) then
							PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
						end
					end
			},
			
			---------------------------------------------- Sweet Rewards
			Button 
			{
				x = 56, y = 409,
				name = "mainmenu_award_button",
				hflip = true,
				Text {
					font = {edwardian_medium, 24, WhiteColor},
					x = 0, y = 0,
					w = kMax, h = kMax - 28,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "mainmenu_sweet"
				},
				Text {
					font = {edwardian_medium, 18, WhiteColor},
					x = 42, y = 20,
					w = kMax - 20, h = kMax - 13,
					flags	= kHAlignLeft + kVAlignCenter,
					label	= "mainmenu_rewards"
				},
				command =
					function()
						SetState("MainMenuScreenTime", 0);
						DoTransition( kFadeToBlack );
						SwapToModal( 'scripts/rewardswindow.lua' );
						--if( not mm_close ) then
					        --mm_close = true;
						    --DoTransition( kFadeToBlack, "SwapToModal( 'scripts/rewardswindow.lua' );" );
						    --PostMessage( CreateNamedMessage( kFadeToBlack, "SwapToModal( 'scripts/rewardswindow.lua' )" ) );
						--end
					end
			},
			---------------------------------------------- Options
			SetStyle(CSMMRight1ButtonStyle),
			Button
			{
				x = 509, y = 467,
				name = "mainmenu_options_button",
				Text{
					font = {edwardian_medium, 22, WhiteColor},
					x = 0, y = 0,
					w = kMax-3, h = kMax-10,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "mainmenu_options"
				},
				command	=
					function()
						DoModal( "scripts/options.lua" );
					end
			},
			---------------------------------------------- High Scores
			Button
			{
				x = 161, y = 467,
				name = "mainmenu_scores_button",
				hflip = true,
				Text {
					font = {edwardian_medium, 20, WhiteColor},
					x = 25, y = 0,
					w = kMax - 20, h = kMax - 15,
					flags = kHAlignCenter + kVAlignCenter,
					label = "mainmenu_scores"
				},
				command =
					function()
						SetState("MainMenuScreenTime", 0);
						DoTransition( kFadeToBlack );
						SwapToModal( 'scripts/hiscore.lua' );
						--if( not mm_close ) then
					        --mm_close = true;
					        --DoTransition( kFadeToBlack, "SwapToModal( 'scripts/hiscore.lua' );" );
						    --PostMessage( CreateNamedMessage( kFadeToBlack, "SwapToModal( 'scripts/hiscore.lua' );" ) );
						--end
					end
			},
		},
		
		-------------------------------------- Copyright
		Text
		{
			x		= 0,
			y		= 584,
			w		= 800,
			h		= 25,
			font	= App_CopyrightFont,
			label	= "app_copyright",
			flags	= kHAlignCenter + kVAlignTop
		},
	}
}

PostMessage( CreateNamedMessage( kFadeFromBlack ) );
SetState("MainMenuScreenTime", 1)

EnableWindow("firstpeek_endless_button", GetConfig("firstpeek") == "1");
EnableWindow("mainmenu_endless_button", not (GetConfig("firstpeek") == "1"));
EnableWindow("firstpeek_scores_button", GetConfig("firstpeek") == "1");
EnableWindow("mainmenu_scores_button", not (GetConfig("firstpeek") == "1"));